@extends('layouts.custommaster')

								@section('content')

								<!--Login Page-->
								<div class="p-5 pt-0">
									<h1 class="mb-2">{{trans('langconvert.menu.login')}}</h1>
									<p class="text-muted">{{trans('langconvert.menu.siginacc')}}</p>
								</div>
								<form class="card-body pt-3" id="login" action="{{route('client.do_login')}}" method="post">
									@csrf
									@honeypot

									<div class="form-group">
										<label class="form-label">{{trans('langconvert.admindashboard.email')}} <span class="text-red">*</span></label>
										<input class="form-control  @error('email') is-invalid @enderror" placeholder="Email" type="email"
											value="{{old('email')}}" name="email" autocomplete="username">
										@error('email')

										<span class="invalid-feedback" role="alert">
											<strong>{{ $message }}</strong>
										</span>
										@enderror

									</div>
									<div class="form-group">
										<label class="form-label">{{trans('langconvert.admindashboard.password')}} <span class="text-red">*</span></label>
										<input class="form-control  @error('password') is-invalid @enderror" placeholder="password" type="password" name="password" autocomplete="current-password">
										@error('password')

										<span class="invalid-feedback" role="alert">
											<strong>{{ $message }}</strong>
										</span>
										@enderror

									</div>
									<div class="form-group">
										<label class="custom-control form-checkbox">
											<input type="checkbox" class="custom-control-input" name="remember" id="remember" {{ old('remember')
												? 'checked' : '' }}>
											<span class="custom-control-label">{{trans('langconvert.menu.rememberme')}}</span>
										</label>
									</div>
									@if(setting('CAPTCHATYPE')=='manual')
										@if(setting('RECAPTCH_ENABLE_LOGIN')=='yes')

										<div class="form-group row">
											<div class="col-md-6">
												<input type="text" id="captcha" class="form-control @error('captcha') is-invalid @enderror" placeholder="Enter Captcha" name="captcha">
												@error('captcha')

													<span class="invalid-feedback" role="alert">
														<strong>{{ $message }}</strong>
													</span>
												@enderror

											</div>
											<div class="col-md-6">
												<div class="captcha">
													<span>{!! captcha_img('') !!}</span>
													<button type="button" class="btn btn-outline-info btn-sm captchabtn"><i class="fe fe-refresh-cw"></i></button>
												</div>
											</div>
										</div>
										@endif
									@endif
									<!--- if Enable the Google ReCaptcha --->
									@if(setting('CAPTCHATYPE')=='google')
										@if(setting('RECAPTCH_ENABLE_LOGIN')=='yes')

										<div class="form-group">
											<div class="g-recaptcha" data-sitekey="{{setting('GOOGLE_RECAPTCHA_KEY')}}"></div>
											@if ($errors->has('g-recaptcha-response'))

											<span class="invalid-feedback" role="alert">
												<strong>{{ $errors->first('g-recaptcha-response') }}</strong>
											</span>
											@endif

										</div>
										@endif
									@endif

									<div class="submit">
										<input class="btn btn-secondary btn-block" type="submit" value="{{trans('langconvert.menu.login')}}"
											onclick="this.disabled=true;this.form.submit();">
									</div>
									<div class="text-center mt-3">
										<a href="{{url('customer/forgotpassword')}}" class="text-primary pb-2">{{trans('langconvert.menu.forgotpass')}}</a>
										@if(setting('REGISTER_DISABLE') == 'on')

										<p class="text-dark mb-0">{{trans('langconvert.menu.doyoulogin')}}<a class="text-primary ms-1"
												href="{{route('auth.register')}}">{{trans('langconvert.menu.register')}}</a></p>
										@endif
										
										<p class="text-dark mb-0"><a class="text-primary ms-1" href="{{url('/')}}">{{trans('langconvert.menu.meback')}}</a></p>
									</div>
								</form>
								<div class="card-body border-top-0 pb-0 pt-0">
									<div class="d-flex justify-content-center">
										@if($socialAuthSettings->facebook_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Facebook" onclick="window.location.href = facebook;"
											data-bs-original-title="Login with Facebook"> <i class="ri-facebook-line"></i> </a>
										@endif
										@if($socialAuthSettings->google_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Google" onclick="window.location.href = google;"
											data-bs-original-title="Login with Google"> <i aria-hidden="true" class="ri-google-line"></i> </a>
										@endif
										@if($socialAuthSettings->twitter_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Google" onclick="window.location.href = twitter;"
											data-bs-original-title="Login with Twitter"> <i aria-hidden="true" class="ri-twitter-line"></i> </a>
										@endif
										@if($socialAuthSettings->envato_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary d-flex justify-content-center sprukoenvato" data-bs-toggle="tooltip"
											title="Login with Envato" onclick="window.location.href = envato;"
											data-bs-original-title="Login with Envato"> 
											<svg  style="enable-background:new 0 0 512 512;" version="1.1" viewBox="0 0 512 512"  xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
												<g id="_x38_5-envato"><g><g><g><path d="M401.225,19.381c-17.059-8.406-103.613,1.196-166.01,61.218      c-98.304,98.418-95.947,228.089-95.947,228.089s-3.248,13.335-17.086-6.011c-30.305-38.727-14.438-127.817-12.651-140.23      c2.508-17.494-8.615-17.999-13.243-12.229c-109.514,152.46-10.616,277.288,54.136,316.912      c75.817,46.386,225.358,46.354,284.922-85.231C509.547,218.042,422.609,29.875,401.225,19.381L401.225,19.381z M401.225,19.381" style="fill:#91D14D;"/></g></g></g></g><g id="Layer_1"/></svg>
											</a>
										@endif
									</div>
								</div>
								<!--Login Page-->
							
								@endsection
		@section('scripts')
		
		<!-- Captcha js-->
		<script src="https://www.google.com/recaptcha/api.js" async defer></script>

		<script type="text/javascript">
            "use strict";

			// Variables
			var facebook = "{{ route('social.login', 'facebook') }}";
			var google = "{{ route('social.login', 'google') }}";
			var twitter = "{{ route('social.login', 'twitter') }}";
			var envato = "{{ route('social.login', 'envato') }}";

			(function($){

				$(".captchabtn").on('click', function(e){
					e.preventDefault();
					$.ajax({
						type:'GET',
						url:'{{route('captcha.reload')}}',
						success: function(res){
							$(".captcha span").html(res.captcha);
						}
					});
				});
				
			})(jQuery);
		</script>
		@endsection